﻿IF NOT EXISTS (SELECT 1 FROM sys.tables WHERE object_id = OBJECT_ID(N'[RespondentBlockRandomization]'))
BEGIN
	CREATE TABLE [RespondentBlockRandomization]
	(		
		[RespondentId] INT NOT NULL,
		[BlockId] INT NOT NULL,
		[Matrix] INT NOT NULL,
		[Position] INT NOT NULL,
		CONSTRAINT [PK_RespondentBlockRandomization] PRIMARY KEY CLUSTERED ([RespondentId], [BlockId], [Matrix] ASC),
		CONSTRAINT [FK_RespondentBlockRandomization_Respondent] FOREIGN KEY([RespondentId]) REFERENCES [Respondent] ([ResRespondent]) ON DELETE CASCADE,	
	)
END
GO

IF NOT EXISTS (SELECT 1 FROM sys.tables WHERE object_id = OBJECT_ID(N'[RespondentQuestionRandomization]'))
BEGIN
	CREATE TABLE [RespondentQuestionRandomization]
	(		
		[RespondentId] INT NOT NULL,
		[QuestionId] INT NOT NULL,
		[Matrix] INT NOT NULL,
		[Position] INT NOT NULL,
		CONSTRAINT [PK_RespondentQuestionRandomization] PRIMARY KEY CLUSTERED ([RespondentId], [QuestionId], [Matrix] ASC),
		CONSTRAINT [FK_RespondentQuestionRandomization_Respondent] FOREIGN KEY([RespondentId]) REFERENCES [Respondent] ([ResRespondent]) ON DELETE CASCADE,	
	)
END
GO

IF NOT EXISTS (SELECT 1 FROM sys.tables WHERE object_id = OBJECT_ID(N'[RespondentVariableRandomization]'))
BEGIN
	CREATE TABLE [RespondentVariableRandomization]
	(		
		[RespondentId] INT NOT NULL,
		[VariableName] NVARCHAR(255) NOT NULL,
		[Matrix] INT NOT NULL,
		[Position] INT NOT NULL,
		CONSTRAINT [PK_RespondentVariableRandomization] PRIMARY KEY CLUSTERED ([RespondentId], [VariableName], [Matrix] ASC),
		CONSTRAINT [FK_RespondentVariableRandomization_Respondent] FOREIGN KEY([RespondentId]) REFERENCES [Respondent] ([ResRespondent]) ON DELETE CASCADE,	
	)
END
GO

IF EXISTS (SELECT 1 FROM sys.objects WHERE object_id = OBJECT_ID(N'[VSE_sp_GetRespondentBlockRandomizationPosition]') AND schema_Id <> SCHEMA_ID('dbo') AND type in (N'P', N'PC'))
    DROP PROCEDURE [VSE_sp_GetRespondentBlockRandomizationPosition]
GO
CREATE PROCEDURE [VSE_sp_GetRespondentBlockRandomizationPosition]
    @respondentId INT,
    @blockId INT,
	@matrix INT
AS
BEGIN
	SELECT [Position]
    FROM [RespondentBlockRandomization]
    WHERE [RespondentId] = @respondentId AND [BlockId] = @blockId AND [Matrix] = @matrix;
END
GO

IF EXISTS (SELECT 1 FROM sys.objects WHERE object_id = OBJECT_ID(N'[VSE_sp_GetRespondentQuestionRandomizationPosition]') AND schema_Id <> SCHEMA_ID('dbo') AND type in (N'P', N'PC'))
    DROP PROCEDURE [VSE_sp_GetRespondentQuestionRandomizationPosition]
GO
CREATE PROCEDURE [VSE_sp_GetRespondentQuestionRandomizationPosition]
    @respondentId INT,
    @questionId INT,
	@matrix INT
AS
BEGIN
	SELECT [Position]
    FROM [RespondentQuestionRandomization]
    WHERE [RespondentId] = @respondentId AND [QuestionId] = @questionId AND [Matrix] = @matrix;
END
GO

IF EXISTS (SELECT 1 FROM sys.objects WHERE object_id = OBJECT_ID(N'[VSE_sp_UpdateRespondentBlockRandomization]') AND schema_Id <> SCHEMA_ID('dbo') AND type in (N'P', N'PC'))
    DROP PROCEDURE [VSE_sp_UpdateRespondentBlockRandomization]
GO
CREATE PROCEDURE [VSE_sp_UpdateRespondentBlockRandomization]
	@respondentId INT,
	@blockId INT,
	@matrix INT,
	@position INT
AS
BEGIN
    UPDATE [RespondentBlockRandomization]
    SET [Position] = @position
    WHERE [RespondentId] = @respondentId AND [BlockId] = @blockId AND [Matrix] = @matrix;

    IF @@ROWCOUNT = 0
    BEGIN
	    INSERT INTO [RespondentBlockRandomization] ([RespondentId], [BlockId], [Matrix], [Position])
	    VALUES (@respondentId, @blockId, @matrix, @position)
    END
END
GO

IF EXISTS (SELECT 1 FROM sys.objects WHERE object_id = OBJECT_ID(N'[VSE_sp_UpdateRespondentQuestionRandomization]') AND schema_Id <> SCHEMA_ID('dbo') AND type in (N'P', N'PC'))
    DROP PROCEDURE [VSE_sp_UpdateRespondentQuestionRandomization]
GO
CREATE PROCEDURE [VSE_sp_UpdateRespondentQuestionRandomization]
	@respondentId INT,
	@matrix INT,
    @questionRandomizations AS [dbo].[RespondentQuestionRandomizationList] READONLY
AS
BEGIN
    UPDATE dest
    SET dest.[Position] = source.[Position]
    FROM [RespondentQuestionRandomization] dest
    INNER JOIN @questionRandomizations source
        ON dest.[RespondentId] = @respondentId
        AND dest.[QuestionId] = source.[QuestionId]
        AND dest.[Matrix] = @matrix;

    INSERT INTO [RespondentQuestionRandomization] ([RespondentId], [QuestionId], [Matrix], [Position])
    SELECT @respondentId, source.[QuestionId], @matrix, source.[Position]
    FROM @questionRandomizations source
    LEFT JOIN [RespondentQuestionRandomization] dest
        ON dest.[RespondentId] = @respondentId
        AND source.[QuestionId] = dest.[QuestionId]
        AND dest.[Matrix] = @matrix
    WHERE dest.[RespondentId] IS NULL;
END
GO

IF EXISTS (SELECT 1 FROM sys.objects WHERE object_id = OBJECT_ID(N'[VSE_sp_UpdateRespondentVariableRandomization]') AND schema_Id <> SCHEMA_ID('dbo') AND type in (N'P', N'PC'))
    DROP PROCEDURE [VSE_sp_UpdateRespondentVariableRandomization]
GO
CREATE PROCEDURE [VSE_sp_UpdateRespondentVariableRandomization]
	@respondentId INT,
	@matrix INT,
    @variableRandomizations AS [dbo].[RespondentVariableRandomizationList] READONLY
AS
BEGIN
    UPDATE dest
    SET dest.[Position] = source.[Position]
    FROM [RespondentVariableRandomization] dest
    INNER JOIN @variableRandomizations source
        ON dest.[RespondentId] = @respondentId
        AND dest.[VariableName] = source.[VariableName]
        AND dest.[Matrix] = @matrix;

    INSERT INTO [RespondentVariableRandomization] ([RespondentId], [VariableName], [Matrix], [Position])
    SELECT @respondentId, source.[VariableName], @matrix, source.[Position]
    FROM @variableRandomizations source
    LEFT JOIN [RespondentVariableRandomization] dest
        ON dest.[RespondentId] = @respondentId
        AND source.[VariableName] = dest.[VariableName]
        AND dest.[Matrix] = @matrix
    WHERE dest.[RespondentId] IS NULL;
END
GO

IF EXISTS (SELECT 1 FROM sys.objects WHERE object_id = OBJECT_ID(N'[A4S_sp_GetRespondentsBlockRandomization]') AND schema_Id <> SCHEMA_ID('dbo') AND type in (N'P', N'PC'))
    DROP PROCEDURE [A4S_sp_GetRespondentsBlockRandomization]
GO
CREATE PROCEDURE [A4S_sp_GetRespondentsBlockRandomization]
	@respondentIds AS [dbo].[RespondentList] READONLY
AS
BEGIN
	SELECT [RespondentId], [BlockId], [Matrix], [Position]
    FROM [RespondentBlockRandomization]
    INNER JOIN @respondentIds ON [RespondentId] = [Id];
END
GO

IF EXISTS (SELECT 1 FROM sys.objects WHERE object_id = OBJECT_ID(N'[A4S_sp_GetRespondentsQuestionRandomization]') AND schema_Id <> SCHEMA_ID('dbo') AND type in (N'P', N'PC'))
    DROP PROCEDURE [A4S_sp_GetRespondentsQuestionRandomization]
GO
CREATE PROCEDURE [A4S_sp_GetRespondentsQuestionRandomization]
	@respondentIds AS [dbo].[RespondentList] READONLY
AS
BEGIN
	SELECT [RespondentId], [QuestionId], [Matrix], [Position]
    FROM [RespondentQuestionRandomization]
    INNER JOIN @respondentIds ON [RespondentId] = [Id];
END
GO

IF EXISTS (SELECT 1 FROM sys.objects WHERE object_id = OBJECT_ID(N'[A4S_sp_GetRespondentsVariableRandomization]') AND schema_Id <> SCHEMA_ID('dbo') AND type in (N'P', N'PC'))
    DROP PROCEDURE [A4S_sp_GetRespondentsVariableRandomization]
GO
CREATE PROCEDURE [A4S_sp_GetRespondentsVariableRandomization]
	@respondentIds AS [dbo].[RespondentList] READONLY
AS
BEGIN
	SELECT [RespondentId], [VariableName], [Matrix], [Position]
    FROM [RespondentVariableRandomization]
    INNER JOIN @respondentIds ON [RespondentId] = [Id];
END
GO

IF EXISTS (SELECT 1 FROM sys.objects WHERE object_id = OBJECT_ID(N'[A4S_sp_GetAllRandomizedElements]') AND schema_Id <> SCHEMA_ID('dbo') AND type in (N'P', N'PC'))
    DROP PROCEDURE [A4S_sp_GetAllRandomizedElements]
GO
CREATE PROCEDURE [A4S_sp_GetAllRandomizedElements]
AS
BEGIN
	SELECT DISTINCT [VariableName] FROM [RespondentVariableDisplayOrder]
	SELECT DISTINCT [VariableName] FROM [RespondentChoiceDisplayOrder]
	SELECT DISTINCT [BlockId] FROM [RespondentBlockRandomization]
	SELECT DISTINCT [QuestionId] FROM [RespondentQuestionRandomization]
	SELECT DISTINCT [VariableName] FROM [RespondentVariableRandomization]
END
GO
